/*
 * Decompiled with CFR 0.152.
 */
package net.customheroes.client.outline;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OutlineBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class OutlineRenderEvent {
    private static boolean isBlockedByWall(Minecraft mc, LivingEntity entity, float partialTick) {
        Vec3 targetPos;
        Vec3 cameraPos = mc.f_91063_.m_109153_().m_90583_();
        BlockHitResult result = mc.f_91073_.m_45547_(new ClipContext(cameraPos, targetPos = entity.m_20191_().m_82399_().m_82520_(0.0, (double)entity.m_20206_() * 0.5, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)mc.f_91074_));
        return result.m_6662_() == HitResult.Type.BLOCK;
    }

    @SubscribeEvent
    public static void onRenderLivingPost(RenderLivingEvent.Post<?, ?> event) {
        LivingEntity entity = event.getEntity();
        Minecraft mc = Minecraft.m_91087_();
        if (!OutlineRenderEvent.isBlockedByWall(mc, entity, event.getPartialTick())) {
            return;
        }
        if (entity == mc.f_91074_) {
            return;
        }
        if (mc.f_91074_ == null) {
            return;
        }
        if (mc.f_91074_.m_20280_((Entity)entity) > 900.0) {
            return;
        }
        MobEffect xrayEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation("custom_heroes_by_de4th13", "x_ray_vision_effect"));
        if (xrayEffect == null || !mc.f_91074_.m_21023_(xrayEffect)) {
            return;
        }
        if (!(entity instanceof Player) && !(entity instanceof Zombie)) {
            return;
        }
        LivingEntityRenderer renderer = event.getRenderer();
        PoseStack poseStack = event.getPoseStack();
        float partialTick = event.getPartialTick();
        float bodyYaw = Mth.m_14179_((float)partialTick, (float)entity.f_20884_, (float)entity.f_20883_);
        OutlineBufferSource outline = mc.m_91269_().m_110109_();
        outline.m_109929_(120, 0, 0, 255);
        poseStack.m_85836_();
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_85837_(0.0, -1.501, 0.0);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(bodyYaw + 180.0f));
        RenderSystem.m_69482_();
        RenderSystem.m_69456_((int)516);
        renderer.m_7200_().m_7695_(poseStack, outline.m_6299_(RenderType.m_110491_((ResourceLocation)renderer.m_5478_((Entity)entity))), event.getPackedLight(), OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.m_69456_((int)515);
        poseStack.m_85849_();
        outline.m_109928_();
    }
}

